<div class="form-box" id="login-box">
    <div class="header">Sign Up</div>
    <?php
    echo $this->Form->create('User', array(
        'inputDefaults' => array(
            'label' => false,
            'div'   => false,
            'class' => 'form-control',
            'error' => array(
                'attributes' => array( 'wrap' => 'span', 'class' => 'help-block' )
            )
        )
    ));
    ?>
    <div class="body bg-gray">
        <?php echo $this->Flash->render(); ?>

        <div class="form-group <?php echo($this->Form->isFieldError('username') ? 'has-error' : ''); ?>">
            <?php echo $this->Form->input('username', array( 'placeholder' => 'Username' )); ?>
        </div>

        <div class="row">
            <div class="col-sm-6">
                <div class="form-group <?php echo($this->Form->isFieldError('password') ? 'has-error' : ''); ?>">
                    <?php echo $this->Form->input('password', array( 'type' => 'password', 'placeholder' => 'Password' )); ?>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="form-group <?php echo($this->Form->isFieldError('confirm_password') ? 'has-error' : ''); ?>">
                    <?php echo $this->Form->input('confirm_password', array( 'type' => 'password', 'placeholder' => 'Re-enter Password' )); ?>
                </div>
            </div>
        </div>
        
        <div class="form-group <?php echo($this->Form->isFieldError('email') ? 'has-error' : ''); ?>">
            <?php echo $this->Form->input('email', array( 'placeholder' => 'Email' )); ?>
        </div>

        <div class="form-group <?php echo($this->Form->isFieldError('confirm_email') ? 'has-error' : ''); ?>">
            <?php echo $this->Form->input('confirm_email', array( 'placeholder' => 'Re-enter Email' )); ?>
        </div>

        <?php if (isset_recaptcha()) {
    ?>
            <div class="form-group">
                <script src='https://www.google.com/recaptcha/api.js' async defer></script>
                <div class="g-recaptcha" data-sitekey="<?php echo Configure::read('Option.recaptcha_siteKey');
    ?>"></div>
                <?php $this->Form->unlockField('g-recaptcha-response');
    ?>
            </div>
        <?php 
} ?>

    </div>
    <div class="footer">

        <div class="form-group">
            <label>
                I agree to the
                <a href="<?php echo $this->Html->url('/pages/terms'); ?>" target="_blank">
                    Terms of Service
                </a>
                and
                <a href="<?php echo $this->Html->url('/pages/privacy'); ?>" target="_blank">
                    Privacy Policy
                </a>
            </label>
        </div>

        <?php
        echo $this->Form->end(array(
            'div'   => array(
                'class' => 'form-group',
            ),
            'label' => 'Sign Up',
            'class' => 'btn bg-olive btn-block'
        ));
        ?>

        <div class="create-account">
            <p>
                Or&nbsp;
                <a href="<?php echo $this->Html->url(array( 'controller' => 'users', 'action' => 'login', 'prefix' => 'members', 'members' => true )); ?>">
                    sign into an existing account
                </a>
            </p>
        </div>


    </div>
</form>
</div>
